% Mikoaj Czajkowski , Wiktor Budziski 
% "Simulation error in maximum likelihood estimation of discrete choice
% models"
%
% Online materials
% 2019-03-08 

% Script calculates regressions and uses these results to
% produce Table 5

% This is an expanded version, employing MTL01 and using more 

% "Table 5. Minimum number of Sobol draws required for desired level of log-likelihood and parameter estimates precision (95% confidence intervals in [] brackets)"

% INPUT: Code uses Output matrix from 'MTL_results05.mat' and 'MTL_results01.mat' which can be generated with MTLcalc.m code

% OUTPUT: Code generates excel spreadsheet with Table 5 (expanded)

% Note: Code has to be run two times, with MTL parameter equal to 0 and 1
% to obtain full table

rng(10000001);
clear
clc

%% Settings 

MTL = 0; % if 0 - use 0.05 MTL, otherwise 0.01
if MTL == 0
    load('MTL_results05.mat')
else
    load('MTL_results01.mat')
end
Output = Output(Output(:,42) == 4,:); % Only Sobol
Names = {'Cons.'; 'Design is: MNL'; 'Design is: OOD'; 'No. of CT'; 'No. of individuals';  'Log of No. of draws';  ...
     'No. of attributes = 10'; 'Log of No. of draws (*10 Att)'; 'Parameter for std';'SQ';'Cost';  ...
     'R2'; 'N'};
Table_out = cell(length(Names)+1,4); % Table with results
Table_out(2:end,1) = Names;
Table_out(1,:) = {' ', 'LL', 'Betas','Z stats'}; 

XX = [Output(:,43) == 1,Output(:,43) == 3, Output(:,45), Output(:,46)/1000,Output(:,47) == 10, log(Output(:,44))];
XX = [XX(:,1:end-1), XX(:,end).*(Output(:,47) == 5), XX(:,end).*(Output(:,47) == 10)];
XX = XX(:, [1:4 6 5 7]);


Exact = 1; % if 0 uses median from simulation, otherwise uses transformation of estimates
SimLL = cell(3,2,3,3); %  (10%, 5%, 1%)x(5,10) x (CT) x NP 
SimB = cell(3,2,3,3); % (10%, 5%, 1%) x (5, 10) x CT x NP
%% Regression for LL

Y = Output(:,1);
X = XX;

X = X(~isnan(Y),:);
Y = Y(~isnan(Y),:);
T = zeros(size(X,2)+1,2);
P = zeros(size(X,2)+1,1);

res=fitlm(X, log(Y));

R2 = res.Rsquared.Ordinary;
stdx = sqrt(diag(res.CoefficientCovariance));
COV1 = res.CoefficientCovariance;
VarX =var(table2array(res.Residuals(:,1)));
T(:,1) =table2array(res.Coefficients(:,1));
T(:, 2) =stdx;
pval = pv(T(:,1, 1), stdx);
P(:, 1) =pval;
for j =1:(size(X,2)+1)
    if P(j,1) <= 0.01
        Table_out(j+1,2) = {[num2str(T(j,1,1), '%8.4f'), '***     ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.05 &&  P(j,1) > 0.01
        Table_out(j+1,2) = {[num2str(T(j,1,1), '%8.4f'), '**      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.1 &&  P(j,1) > 0.05
        Table_out(j+1,2) = {[num2str(T(j,1,1), '%8.4f'), '*      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) > 0.1
        Table_out(j+1,2) = {[num2str(T(j,1,1), '%8.4f'), '       ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    end
end
Table_out(size(Table_out,1)-1,2) = {num2str(R2, '%1.4f')};
Table_out(size(Table_out,1),2) = {num2str(size(Y,1), '%8.4f')};

% Simulation for Table 5

SimX = mvnrnd(T(:,1)', res.CoefficientCovariance, 10000);
SimXX = zeros(10000,6,2);
SimXX(:,:,1) = [SimX(:,4)*4,SimX(:,4)*8,SimX(:,4)*12, SimX(:,5)*0.4,SimX(:,5)*0.8,SimX(:,5)*1.2]; % CT and NP
SimXX(:,:,2) = [SimX(:,4)*4,SimX(:,4)*8,SimX(:,4)*12, SimX(:,5)*0.4,SimX(:,5)*0.8,SimX(:,5)*1.2]; % CT and NP
SimXXExact = zeros(6,2);
SimXXExact(:,1) = [T(4,1)*4,T(4,1)*8,T(4,1)*12, T(5,1)*0.4,T(5,1)*0.8,T(5,1)*1.2]';
SimXXExact(:,2)= [T(4,1)*4,T(4,1)*8,T(4,1)*12, T(5,1)*0.4,T(5,1)*0.8,T(5,1)*1.2]';

SimXXX = [0*SimX(:,7), SimX(:,7)]; % 5 or 10 att
SimXXXExact = [0, T(7,1)];
SimCost = [SimX(:,6), SimX(:,8)];
SimCostExact = [T(6,1), T(8,1)];
TmpX = [log(chi2inv(0.9,1)/2),log(chi2inv(0.95,1)/2),log(chi2inv(0.99,1)/2)];
for i = 1:3
    for j = 1:3
        for k = 1:2
            for l = 1:3
                MinDraws = exp((SimX(:,1) + SimXX(:,i,k) + SimXX(:,3+j,k)+ SimXXX(:,k) - TmpX(l))./(-SimCost(:,k)));
                if Exact == 0
                    SimLL(l,k,j,i) =  {[num2str(median(MinDraws), '%8.0f'), '                ', '[', num2str(prctile(MinDraws, 2.5), '%8.0f'), '-',num2str(prctile(MinDraws, 97.5), '%8.0f'), ']']};
                else
                    MinDrawsExact = exp((T(1,1)+ SimXXExact(i,k) + SimXXExact(3+j,k)+ SimXXXExact(k) - TmpX(l))./(-SimCostExact(k)));
                    SimLL(l,k,j,i) =  {[num2str(MinDrawsExact, '%8.0f'), '                ', '[', num2str(prctile(MinDraws, 2.5), '%8.0f'), '-',num2str(prctile(MinDraws, 97.5), '%8.0f'), ']']};

                end
            end
        end
    end
end
SimLL = reshape(SimLL, [6,9]);
   
%% Regression for Beta


Y = reshape(Output(:,2:21), [size(Output,1)*20,1]);
X = XX;
X = repmat(X, [20,1]);

Tmp2 = size(Output,1);
StdX = zeros(Tmp2,20);

StdX(XX(:,6) == 0,6:10) = 1;
StdX(XX(:,6) == 1,11:20) = 1;
StdX = reshape(StdX, [Tmp2*20,1]);
SQ = zeros(Tmp2,20);
SQ(XX(:,6) == 0,[1 6]) = 1;
SQ(XX(:,6) == 1,[1 11]) = 1;
SQ = reshape(SQ, [Tmp2*20,1]);
Cost = zeros(Tmp2,20);
Cost(XX(:,6) == 0,[5 10]) = 1;
Cost(XX(:,6) == 1,[10 20]) = 1;
Cost = reshape(Cost, [Tmp2*20,1]);


X = [X, [StdX, SQ, Cost]];
X = X(~isnan(Y),:);
Y = Y(~isnan(Y),:);

T = zeros(size(X,2)+1,2);
P = zeros(size(X,2)+1,1);

res=fitlm(X, log(Y));

R2 = res.Rsquared.Ordinary;
stdx = sqrt(diag(res.CoefficientCovariance));
VarX =var(table2array(res.Residuals(:,1)));

COV2 = res.CoefficientCovariance;
T(:,1) =table2array(res.Coefficients(:,1));
T(:, 2) =stdx;
pval = pv(T(:,1, 1), stdx);
P(:, 1) =pval;

for j =1:(size(X,2)+1)
    if P(j,1) <= 0.01
        Table_out(j+1,3) = {[num2str(T(j,1,1), '%8.4f'), '***     ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.05 &&  P(j,1) > 0.01
        Table_out(j+1,3) = {[num2str(T(j,1,1), '%8.4f'), '**      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.1 &&  P(j,1) > 0.05
        Table_out(j+1,3) = {[num2str(T(j,1,1), '%8.4f'), '*      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) > 0.1
        Table_out(j+1,3) = {[num2str(T(j,1,1), '%8.4f'), '       ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    end
end
Table_out(size(Table_out,1)-1,3) = {num2str(R2, '%1.4f')};
Table_out(size(Table_out,1),3) = {num2str(size(Y,1), '%8.4f')};

SimX = mvnrnd(T(:,1)', res.CoefficientCovariance, 10000);
SimXX = zeros(10000,6,2);
SimXX(:,:,1) = [SimX(:,4)*4,SimX(:,4)*8,SimX(:,4)*12, SimX(:,5)*0.4,SimX(:,5)*0.8,SimX(:,5)*1.2]; % CT and NP
SimXX(:,:,2) = [SimX(:,4)*4,SimX(:,4)*8,SimX(:,4)*12, SimX(:,5)*0.4,SimX(:,5)*0.8,SimX(:,5)*1.2]; % CT and NP
SimXXExact = zeros(6,2);
SimXXExact(:,1) = [T(4,1)*4,T(4,1)*8,T(4,1)*12, T(5,1)*0.4,T(5,1)*0.8,T(5,1)*1.2]';
SimXXExact(:,2)= [T(4,1)*4,T(4,1)*8,T(4,1)*12, T(5,1)*0.4,T(5,1)*0.8,T(5,1)*1.2]';

SimXXX = [SimX(:,9)+ SimX(:,10),SimX(:,9)+ SimX(:,10)]; % Only Stdx - SQ 
SimXXXExact = [T(9,1)+T(10,1),T(9,1)+T(10,1)];

SimCost = [SimX(:,6), SimX(:,8)];
SimCostExact = [T(6,1), T(8,1)];

SimXXXX = [0*SimX(:,7), SimX(:,7)]; % 5 or 10 att
SimXXXXExact = [0, T(7,1)];

TmpX = [log(0.05),log(0.025), log(0.005)]; % 5% and 1% (true value is 0.5 - std of random parameter)
for i = 1:3
    for j = 1:3
        for k = 1:3
            for l = 1:2
                MinDraws = exp((SimX(:,1)+ SimXX(:,i,l) + SimXX(:,3+j,l) + SimXXX(:,l) + SimXXXX(:,l)- TmpX(k))./(-SimCost(:,l)));
                if Exact == 0
                     SimB(k,l, j,i) =  {[num2str(median(MinDraws), '%8.0f'), '                           ', '[', num2str(prctile(MinDraws, 2.5), '%8.0f'), '-',num2str(prctile(MinDraws, 97.5), '%8.0f'), ']']};
                else
                    MinDrawsExact = exp((T(1,1) + SimXXExact(i,l) + SimXXExact(3+j,l) + SimXXXXExact(l) +SimXXXExact(l)- TmpX(k))./(-SimCostExact(l)));
                    SimB(k,l, j,i) =  {[num2str(MinDrawsExact, '%8.0f'), '                           ', '[', num2str(prctile(MinDraws, 2.5), '%8.0f'), '-',num2str(prctile(MinDraws, 97.5), '%8.0f'), ']']};
                end
            end
        end
    end
end
SimB = reshape(SimB, [6,9]);


%% Regression for Z-stats

Y = reshape(Output(:,22:41), [size(Output,1)*20,1]);
X = XX;
X = repmat(X, [20,1]);

StdX = zeros(Tmp2,20);

StdX(XX(:,6) == 0,6:10) = 1;
StdX(XX(:,6) == 1,11:20) = 1;
StdX = reshape(StdX, [Tmp2*20,1]);
SQ = zeros(Tmp2,20);
SQ(XX(:,6) == 0,[1 6]) = 1;
SQ(XX(:,6) == 1,[1 11]) = 1;
SQ = reshape(SQ, [Tmp2*20,1]);
Cost = zeros(Tmp2,20);
Cost(XX(:,6) == 0,[5 10]) = 1;
Cost(XX(:,6) == 1,[10 20]) = 1;
Cost = reshape(Cost, [Tmp2*20,1]);

X = [X, [StdX, SQ, Cost]];
X = X(~isnan(Y),:);
Y = Y(~isnan(Y),:);

T = zeros(size(X,2)+1,2);
P = zeros(size(X,2)+1,1);

res=fitlm(X, log(Y));

R2 = res.Rsquared.Ordinary;
stdx = sqrt(diag(res.CoefficientCovariance));
COV3 = res.CoefficientCovariance;
VarX =var(table2array(res.Residuals(:,1)));
T(:,1) =table2array(res.Coefficients(:,1));
T(:, 2) =stdx;
pval = pv(T(:,1, 1), stdx);
P(:, 1) =pval;

for j =1:(size(X,2)+1)
    if P(j,1) <= 0.01
        Table_out(j+1,4) = {[num2str(T(j,1,1), '%8.4f'), '***     ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.05 &&  P(j,1) > 0.01
        Table_out(j+1,4) = {[num2str(T(j,1,1), '%8.4f'), '**      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.1 &&  P(j,1) > 0.05
        Table_out(j+1,4) = {[num2str(T(j,1,1), '%8.4f'), '*      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) > 0.1
        Table_out(j+1,4) = {[num2str(T(j,1,1), '%8.4f'), '       ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
 
    end
end

Table_out(size(Table_out,1)-1,4) = {num2str(R2, '%1.4f')};
Table_out(size(Table_out,1),4) = {num2str(size(Y,1), '%8.4f')};
Table_out = Table_out([1:2 8 7 9 5 6 4 3 10:14],:);
Name = 'Results20190308.xls';

Head = {'4', '4', '4', '8', '8', '8', '12', '12', '12'; '400' , '800', '1200', '400' , '800', '1200','400' , '800', '1200'};
xlswrite(Name, Head, 'Table 5 (expanded)', 'B1');

if MTL == 0
    xlswrite(Name, SimLL(3:-1:1,:), 'Table 5 (expanded)', 'B3');
    NameX = {'MTL = 0.05 / 5 attributes / LR (0.01)'; 'MTL = 0.05 / 5 attributes / LR (0.05)'; 'MTL = 0.05 / 5 attributes / LR (0.10)'};
    xlswrite(Name, NameX, 'Table 5 (expanded)', 'A3');
    
    NameX = {'MTL = 0.05 / 5 attributes / B (0.10)'; 'MTL = 0.05 / 5 attributes / B (0.05)'; 'MTL = 0.05 / 5 attributes / B (0.01)';};
    xlswrite(Name, SimB(1:3,:), 'Table 5 (expanded)', 'B6');
    xlswrite(Name, NameX, 'Table 5 (expanded)', 'A6');
    
    
    xlswrite(Name, SimLL(6:-1:4,:), 'Table 5 (expanded)', 'B17');
    NameX = {'MTL = 0.05 / 10 attributes / LR (0.01)'; 'MTL = 0.05 / 10 attributes / LR (0.05)'; 'MTL = 0.05 / 10 attributes / LR (0.10)'};
    xlswrite(Name, NameX, 'Table 5 (expanded)', 'A17');
    
    NameX = {'MTL = 0.05 / 10 attributes / B (0.10)'; 'MTL = 0.05 / 10 attributes / B (0.05)'; 'MTL = 0.05 / 10 attributes / B (0.01)';};
    xlswrite(Name, SimB(4:6,:), 'Table 5 (expanded)', 'B20');
    xlswrite(Name, NameX, 'Table 5 (expanded)', 'A20');
    
else
    xlswrite(Name, SimLL(3:-1:1,:), 'Table 5 (expanded)', 'B10');
    NameX = {'MTL = 0.01 / 5 attributes / LR (0.01)'; 'MTL = 0.01 / 5 attributes / LR (0.05)'; 'MTL = 0.01 / 5 attributes / LR (0.10)'};
    xlswrite(Name, NameX, 'Table 5 (expanded)', 'A10');
    
    NameX = {'MTL = 0.01 / 5 attributes / B (0.10)'; 'MTL = 0.01 / 5 attributes / B (0.05)'; 'MTL = 0.01 / 5 attributes / B (0.01)';};
    xlswrite(Name, SimB(1:3,:), 'Table 5 (expanded)', 'B13');
    xlswrite(Name, NameX, 'Table 5 (expanded)', 'A13');
    
    xlswrite(Name, SimLL(6:-1:4,:), 'Table 5 (expanded)', 'B24');
    NameX = {'MTL = 0.01 / 10 attributes / LR (0.01)'; 'MTL = 0.01 / 10 attributes / LR (0.05)'; 'MTL = 0.01 / 10 attributes / LR (0.10)'};
    xlswrite(Name, NameX, 'Table 5 (expanded)', 'A24');
    
    NameX = {'MTL = 0.01 / 10 attributes / B (0.10)'; 'MTL = 0.01 / 10 attributes / B (0.05)'; 'MTL = 0.01 / 10 attributes / B (0.01)';};
    xlswrite(Name, SimB(4:6,:), 'Table 5 (expanded)', 'B27');
    xlswrite(Name, NameX, 'Table 5 (expanded)', 'A27');
    
end